#!/usr/bin/perl
##Author: Lance Vermilion <rancid(a)gheek.net>
#Description: Add/Rem/Chg devices in/to/from 
#             rancids router.db through a web
#             interface.
#TODOs:
# - Make the code much cleaner and better 
#   documented.
# - Make the web interface to this script 
#   much prettier.
# - Need a way to handle multiple adds, but for
#   now the option for single adds will surfice.
#
#Date: 11/21/06         
#Version: 0.1
################################################
use strict;
use warnings;
use CGI;

#
# Declare my global variables
#
my $query = new CGI;
my $group = 'BWI'; # This is the group from LIST_OF_GROUPS in rancid.conf
my $device = $query->param('device');
my $type = $query->param('type');
my $status = $query->param('status');
my $dowhat = $query->param('dowhat');
my $view = $query->param('view');
my $exists = 0; # Presume by default that the device doesn't already exist, set to 1 if it exists.
my $error = 0; # If there isn't and exact match then I want an error of 1
my $errchk; # Used to verify that the error is true
my $errchk1; # Used to verify that the error is true
my $upcount = 0; # Count the number of interfaces that are up before we do any changes
my $downcount = 0; # Count the number of interfaces that are down before we do any changes
my $existsline = ''; # if I find the device name in the existing list save it and flag me with a 1
my $modification; # This the device name that I want to use
my $what; # This is the complete error tha I want to use.
my $upcountnew = 0; # Count the number of interface that are up after we did the changes
my $downcountnew = 0; # Count the number of interface that are down after we did the changes
my $ranciddb_count = 0; # I need to count the number of entries in the original router.db array
my @ranciddb_new; # I need an array to hold the new router.db so here it is.
my $ranciddb_new_count = 0; # I need to count the number of entries in the new router.db array
if (!defined $view)
{
chomp ($device, $type, $status, $dowhat);
}

#
# Here is my Usage page I want to generate and display to the user if they fail to meet x requirements
# I also allow one argument to be passed in, it can be a string or anything else.
#
sub DieNow ($) {
  my $msg = shift;
  print <<DIENOW;
Content-type: text/html

<html>
  <head>
    <title>Error</title>
  </head>
  <body bgcolor="#fff5c8">
    <h1>Error</h1>
    <p>
    $msg
    <hr>
  </body>
</html>
DIENOW
  exit 0;
}


#
# Get the string arugment that was sent by the Web server
# and make sure the user wants to change the router.db
# and not just view the router.db
#
if (!defined $view)
{
  if ( (!defined $device || $device eq "") or
     (!defined $type || $type eq "") or
     (!defined $status || $status eq "") or
     (!defined $dowhat || $dowhat eq "") )
  {
DieNow "<pre>Variables not defined completely.\n
The following fields must be defined.\n
Device: \"$device\"\n
Type: \"$type\"\n
Status: \"$status\"\n
Do What: \"$dowhat\"\n</pre>";
  }
}

#
# Populate the @ranciddb with the current router.db 
# then simply get a count of the total entries in
# the router.db
#
my @ranciddb = `cat /usr/local/rancid/var/$group/router.db`;
$ranciddb_count = scalar(@ranciddb);

#
# If the user does not want to just view the config
# then parse the config and create the new rancid.db
# but hold it in an array for printing later.
#
if ( !defined $view )
{
  for my $line (@ranciddb)
  {
    $upcount++ if $line =~ /up$/;         #Count the number of original up devices
    $downcount++ if $line =~ /down$/;     #Count the number of original down devices
    my ($d, $t, $s) = split(/:/, $line);  #Split the line so I can match on each piece of the line
    chomp ($d,$t,$s);                     #remove all trailing \r\n\s
    if ($d =~ /$device/)
    {
      #
      # If the device submitted by the user matches a device listed in the router.db then mark it as existing.
      #
      $exists = 1; # I have a tenative match between the submitted device name and device name in rancid
      $error = 1 if $d ne $device;        # If I find a match I should never get a error here, just for safety.

      #
      # If you are going to add a device make sure it doesn't already exist
      # If it does already exist capture the line that it matches.
      #
      if ( $dowhat eq "add" )
      {
        $error = 1 if $t ne $type;
        $error = 1 if $s ne $status;
        $existsline = $line if ($dowhat eq "add");
      }
      #
      # If you are going to change a device make sure it already exists
      # If it does already exist capture the line that it matches.
      # and add it to the new router.db array
      #
      elsif ( $dowhat eq "chg" ) 
      {
        $error = 0 if $t ne $type;
        $error = 0 if $s ne $status;
        $existsline = $line if ($dowhat eq "chg");
        my $newline = "$device:$type:$status";
        push (@ranciddb_new, $newline);
        next;
      }
      #
      # If you are going to remove a device make sure it already exists
      # and skip to the next line in the original router.db
      #
      elsif ( $dowhat eq "rem" ) 
      {
        $error = 1 if $t ne $type;
        $error = 1 if $s ne $status;
        next if ( $error ne 1 );
      }

      $existsline = $line if ($dowhat eq "add" or $dowhat eq "chg");
      $errchk = "$d:$t:$s";
      $errchk1 = "$device:$type:$status";
    }
    push (@ranciddb_new, $line);
  }
}
#
# If we are viewing the router.db then count the:
# total up devices
# total down devices
#
else
{
  for my $line (@ranciddb)
  {
    $upcount++ if $line =~ /up$/;
    $downcount++ if $line =~ /down$/;
  }
  $exists = 0;
}

#
# If you are not viewing the router.db and acutally changing it then 
# make sure you account for user error. (ex. trying to remove a 
# device that doesn't exist.
#
if (!defined $view)
{
  push (@ranciddb_new, "$device:$type:$status") if ($exists ne 1 && $dowhat eq "add");
  $ranciddb_new_count = scalar(@ranciddb_new) if ($error ne 1);
  $modification = "$device:$type:$status";
  $what = "no match for <font size=2><br>\"$device:$type:$status\"</font><br>but looks similar to<br><font size=2>\"$errchk\"</font>" if ($error eq "1");
  $what = "had <br>\"$device:$type:$status\" added" if ($dowhat eq "add" && $exists eq 0);
  $what = "did NOT have <br>\"$device:$type:$status\" added" if ($dowhat eq "add" && $exists eq 1);
  $what = "had <br>\"$existsline\" <br> changed to <br> \"$modification\"" if ($dowhat eq "chg");
  #$what = "did NOT have <br>\"$modification\" changed." if ($dowhat eq "chg" && $error eq 1);
  $what = "did NOT have <br>\"$modification\" changed." if (($exists eq 1 && $dowhat eq "chg" && $error eq 1) || ($dowhat eq "chg" && $error eq 1) || ($dowhat eq "chg" && $exists eq 0));
  $what = "had <br>\"$device:$type:$status\" removed" if ($dowhat eq "rem" && $error ne 1);
  #$what = "did NOT have <br>\"$device:$type:$status\" removed" if ($dowhat eq "rem" && $exists ne 1 && $error eq 1);
  $what = "did NOT have <br>\"$device:$type:$status\" removed" if (($exists eq 1 && $dowhat eq "rem" && $error eq 1) || ($dowhat eq "rem" && $error eq 1) || ($dowhat eq "rem" && $exists ne 1));
}
#
# If the user wants to view the router.db then make the user message clear you are viewing.
#
elsif (defined $view)
{
  $modification = "had NOTHING";
  $what = "$modification done\n";
  $ranciddb_new_count = $ranciddb_count if ($error eq 1);
}

#
# Count the number of total up devices in the new rancid.db array
# Count the number of total down devices in the new rancid.db array
#
for my $line (@ranciddb_new)
{
  $upcountnew++ if $line =~ /up$/;
  $downcountnew++ if $line =~ /down$/;
}
#
# Output a web page that shows the matches.
#
print
  "Content-type: text/html\n\n" .
  "<html><head>\n" .
  "<title>Rancid router.db</title>\n" .
  "</head>\n" .
  "<body bgcolor=\"white\">\n" .
  "<br>" .
  "<br>" .
  "<h3>Rancids router.db \n" . 
  "$what\n" .
  "</h3>\n" .
  "<pre> router.db Summary\n" .
  " ----------------------------------------\n" .
  " Previous total entries: $ranciddb_count\n" .
  " Devices had Up state:   $upcount\n" .
  " Devices had Down state: $downcount\n" .
  " ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n" .
  " New total entries:      $ranciddb_new_count\n" .
  " Devices in Up state:    $upcountnew\n" .
  " Devices in Down state:  $downcountnew\n</pre>" .
#  "<p> $errchk\n" .                  # Uncomment to see what line from router.db
#  "<br> $errchk1\n" .                # Uncomment to see what the user submitted
#  "<br> $error\n" .                  # Uncomment to see the error flag 1 = true, 0 = false
  "\n";
print "<pre>\n";
print 'device:type:status' . "\n";
print "<hr>\n";

if (!defined $view)
{
  if ($exists eq 1 && $dowhat eq "add")
  {
    print "ERROR: \"$device\" matches \"$existsline\" in router.db.\n\n To add a device the device name (with FQDN), type and status must be unique.";
  }
  elsif (($exists eq 1 && $dowhat eq "rem" && $error eq 1) || ($dowhat eq "rem" && $error eq 1) || ($dowhat eq "rem" && $exists ne 1))
  {
    print "ERROR: \"$device:$type:$status\" does NOT match exactly to anything in router.db.\n\n To remove a device the device name (with FQDN), type and status\n must be match exactly to the existing entry.";
  }
  elsif (($exists eq 1 && $dowhat eq "chg" && $error eq 1) || ($dowhat eq "chg" && $error eq 1) || ($dowhat eq "chg" && $exists ne 1))
  {
    print "ERROR: \"$device:$type:$status\" does NOT match exactly to anything in router.db.\n\n To change a device the device name (with FQDN), must exist in the router.db.";
  }
  else
  {
    
    unlink("/usr/local/rancid/var/$group/router.db");      #Remove the old router.db file
    open FILE, ">/usr/local/rancid/var/$group/router.db";  #Open the new router.db file
    for my $line (@ranciddb_new)                   #Populate the new router.db file
    {
      chomp $line;
      print FILE "$line\n";                        #Print the router.db contents to the router.db file
      print "$line\n";                             #Print the router.db contents to the user
    }
    close FILE;                                    #Close the new router.db file
  }
}
#
# The user just wants to view the router.db so just print it out with 
# a little header stating we are view the existing router.db
else
{
  print "#" x 32 . "\n";
  print " VIEWING THE EXISTING router.db\n";
  print "#" x 32 . "\n";
  for my $line (@ranciddb)
  {
    chomp $line;
    print "$line\n";
  }
}
print "\n" .
"<hr>\n" .
"</body></html>\n";

exit 0;
